#!/bin/bash
# Version 1

# Tries to stop the 7dtd instance given as first parameter.
# Returns:
#  0 : Done
#  1 : Was not running
#  2 : No instance name given
#  3 : No such instance

. /usr/local/bin/7dtd-common.sh
checkRootLoadConf

checkInstance $1

res=$(isRunning $1)
if [ $res -eq 1 ]; then
	telnetCommand shutdown
	start-stop-daemon --stop --pidfile $(getInstancePath $1)/7dtd.pid
	rm $(getInstancePath $1)/7dtd.pid
	echo "Done"	
	exit 0
else
	echo "7dtd instance $1 is NOT running"
	exit 1
fi
