#!/bin/bash
# Version 1

# Checks if the 7dtd instance given as first parameter is running.
# Returns:
#  0 : Running
#  1 : Not running
#  2 : No instance name given
#  3 : No such instance

. /usr/local/bin/7dtd-common.sh
checkRootLoadConf

checkInstance $1

res=$(isRunning $1)
if [ $res -eq 1 ]; then
	echo "7dtd instance $1 is running"
	echo "Open ports:"
	netstat -nlp | grep 15161 | sed -r 's/^.*[^ :]*:([^ ]*).*[^ :]*:[^ ]*.*/    \1/g' | sort
	exit 0
else
	echo "7dtd instance $1 is NOT running"
	exit 1
fi
