#!/bin/bash
# Version 1

# Lists available 7dtd instances.
# Returns:
#  0
. /usr/local/bin/7dtd-common.sh
checkRootLoadConf

printf "%-*s | %-*s | %-*s\n" 20 "Instance name" 8 "Running" 7 "Players"
printf -v line "%*s-+-%*s-+-%*s\n" 20 " " 8 " " 7 " "
echo ${line// /-}
for I in $SDTD_BASE/instances/*; do
	ins=`basename $I`
	run=$(isRunning $ins)
	if [ $run -eq 1 ]; then
		run="yes"
	else
		run="no"
	fi

	tel=$(telnetCommand $ins lp)
	max=$(getConfigValue $ins ServerMaxPlayerCount)
	cur=`echo $tel | sed "s/\r/\n/g" | sed "s/^ //g" | grep "Total of " | cut -d\  -f 3`
	
	printf "%-*s | %*s |   %2d/%2d\n" 20 "$ins" 8 "$run" $cur $max
done
exit 0
