using System;
using System.Collections.Generic;

public class SayToPlayer : ConsoleCommand
{
	public SayToPlayer (ConsoleSdtd cons) : base(cons)
	{
	}

	public override string Description ()
	{
		return "send a message to a single player";
	}

	public override string[] Names ()
	{
		return new string[] { "sayplayer", "pm" };
	}

	private void SendMessage (ClientInfo _receiver, string _sender, string _message)
	{
		CommonMappingFunctions.GetConnectionManager ().networkView.RPC ("RPC_ChatMessage", _receiver.networkPlayer,
				new object[] { _message, -1, _sender + " (PM)", true	});
		string receiverName = CommonMappingFunctions.GetPlayerName (_receiver);
		m_Console.md000a ("Message to player " + (receiverName != null ? "\"" + receiverName + "\"" : "unknownName") + " sent with sender \"" + _sender + "\"");
	}

	private void RunInternal (string _sender, string[] _params)
	{
		if (_params.Length < 2) {
			m_Console.md000a ("Usage: sayplayer <playername|entityid> <message>");
			return;
		}

		string message = _params [1];
		for (int i = 2; i < _params.Length; i++) {
			message += " " + _params [i];
		}

		ClientInfo ci = CommonMappingFunctions.GetClientInfoFromNameOrID (_params [0]);
		if (ci != null) {
			SendMessage (ci, _sender, message);
		} else {
			m_Console.md000a ("Playername or entity ID not found.");
		}
	}

	public override void ExecuteRemote (string _sender, string[] _params)
	{
		try {
			this.m_Console.md000a (string.Format ("{0} executing remote command '{1}' {2}", _sender, this.Names () [0], string.Join (" ", _params)));
			ClientInfo ci = CommonMappingFunctions.GetClientInfoFromSteamID (_sender);
			if (ci != null) {
				_sender = CommonMappingFunctions.GetPlayerName (ci);
			}
			RunInternal (_sender, _params);
		} catch (Exception e) {
			Log.Out ("Error in SayToPlayer.ExecuteRemote: " + e);
		}
	}

	public override void Run (string[] _params)
	{
		try {
			RunInternal ("Server", _params);
		} catch (Exception e) {
			Log.Out ("Error in SayToPlayer.Run: " + e);
		}
	}
}

