using System;
using Mono.Cecil;
using Mono.Collections.Generic;

namespace NamePatcher
{
	public class ManualPatches
	{
		delegate bool MatchField (FieldDefinition fd,TypeReference fdType);

		delegate bool MatchMethod (MethodDefinition md,bool isConstructor,TypeReference retType,int paramCount,Collection<ParameterDefinition> paramList);

		static FieldDefinition getFieldInType (TypeDefinition type, MatchField matcher)
		{
			FieldDefinition field = null;
			if (type != null) {
				foreach (FieldDefinition fd in type.Fields) {
					TypeReference fdType = fd.FieldType;
					if (matcher (fd, fdType)) {
						if (field != null) {
							Console.WriteLine ("ERROR: Multiple matching fields found!");
							return null;
						}
						field = fd;
					}
				}
			}
			return field;
		}

		static MethodDefinition getMethodInType (TypeDefinition type, MatchMethod matcher)
		{
			MethodDefinition method = null;
			if (type != null) {
				foreach (MethodDefinition md in type.Methods) {
					bool cons = md.IsConstructor;
					TypeReference ret = md.ReturnType;
					int pCount = md.Parameters.Count;
					if (matcher (md, cons, ret, pCount, md.Parameters)) {
						if (method != null) {
							Console.WriteLine ("ERROR: Multiple matching methods found!");
							return null;
						}
						method = md;
					}
				}
			}
			return method;
		}

		static void renameMember (IMemberDefinition fd, string newName)
		{
			NameNormalizer.setName (fd, newName);
		}

		static void makeFieldPublic (FieldDefinition fd)
		{
			fd.Attributes = fd.Attributes & (~Mono.Cecil.FieldAttributes.Private) | Mono.Cecil.FieldAttributes.Public;
		}

		public static void applyManualPatches (ModuleDefinition mainModule)
		{
			renameMember (mainModule.GetType ("ItemBlock").BaseType.Resolve (), "ItemBase");

			FieldDefinition fd;
			MethodDefinition md;


			fd = getFieldInType (mainModule.GetType ("Authenticator"), (field, fieldType) => {
				return fieldType.FullName.Contains ("Dictionary") && fieldType.FullName.Contains ("System.String"); }
			);
			if (fd != null) {
				makeFieldPublic (fd);
				renameMember (fd, "usersToIDs");
			} else {
				Console.WriteLine ("FAILED: Authenticator.usersToIDs");
			}


			fd = getFieldInType (mainModule.GetType ("PlayerDataFile"), (field, fieldType) => {
				return field.Name.Equals ("inventory") && fieldType.IsArray; }
			);
			if (fd != null) {
				TypeReference fdType = fd.FieldType;
				TypeDefinition fdTypeDef = fdType.Resolve ();

				FieldDefinition fd2 = getFieldInType (fdTypeDef, (field, fieldType) => {
					return fieldType.FullName.Equals ("System.Int32"); }
				);
				if (fd2 != null) {
					renameMember (fd2, "count");
				} else {
					Console.WriteLine ("FAILED: InventoryField.count");
				}

				fd2 = getFieldInType (fdTypeDef, (field, fieldType) => {
					return fieldType.FullName.Equals ("ItemValue"); }
				);
				if (fd2 != null) {
					renameMember (fd2, "itemValue");
				} else {
					Console.WriteLine ("FAILED: InventoryField.itemValue");
				}

				renameMember (fdTypeDef, "InventoryField");
			} else {
				Console.WriteLine ("FAILED: Locate PlayerDataFile.inventory");
			}


			fd = getFieldInType (mainModule.GetType ("AdminTools"), (field, fieldType) => {
				return fieldType.FullName.Contains ("List") && fieldType.FullName.Contains ("AdminToolsCommandPermissions"); }
			);
			if (fd != null) {
				makeFieldPublic (fd);
				renameMember (fd, "commandPermissions");
			} else {
				Console.WriteLine ("FAILED: AdminTools.commandPermissions");
			}


			fd = getFieldInType (mainModule.GetType ("World"), (field, fieldType) => {
				return fieldType.FullName.Equals ("System.UInt64"); }
			);
			if (fd != null) {
				renameMember (fd, "gameTime");
			} else {
				Console.WriteLine ("FAILED: World.gameTime");
			}


			fd = getFieldInType (mainModule.GetType ("GameManager"), (field, fieldType) => {
				return fieldType.FullName.Equals ("ConnectionManager"); }
			);
			if (fd != null) {
				makeFieldPublic (fd);
				renameMember (fd, "connectionManager");
			} else {
				Console.WriteLine ("FAILED: GameMananger.connectionManager");
			}


			fd = getFieldInType (mainModule.GetType ("ConnectionManager"), (field, fieldType) => {
				return fieldType.FullName.Equals ("GameManager"); }
			);
			if (fd != null) {
				makeFieldPublic (fd);
				renameMember (fd, "gameManager");
			} else {
				Console.WriteLine ("FAILED: ConnectionManager.gameManager");
			}


			fd = getFieldInType (mainModule.GetType ("ConnectionManager"), (field, fieldType) => {
				return fieldType.FullName.Contains ("Dictionary") && fieldType.FullName.Contains ("ClientInfo"); }
			);
			if (fd != null) {
				makeFieldPublic (fd);
				renameMember (fd, "connectedClients");
			} else {
				Console.WriteLine ("FAILED: ConnectionManager.connectedClients");
			}


			fd = getFieldInType (mainModule.GetType ("ConnectionManager"), (field, fieldType) => {
				return fieldType.FullName.Contains ("Dictionary") && fieldType.FullName.Contains ("System.Int32,System.Int32"); }
			);
			if (fd != null) {
				makeFieldPublic (fd);
				renameMember (fd, "mapClientToEntity");
			} else {
				Console.WriteLine ("FAILED: ConnectionManager.mapClientToEntity");
			}


			TypeDefinition typeConsole = null;

			fd = getFieldInType (mainModule.GetType ("NetTelnetServer"), (field, fieldType) => {
				return NameNormalizer.makeValidName (fieldType.Name) != null; }
			);
			if (fd != null) {
				typeConsole = fd.FieldType.Resolve ();
				renameMember (fd, "console");
			} else {
				Console.WriteLine ("FAILED: NetTelnetServer.console");
			}


			if (typeConsole != null) {
				// Rename class ConsoleSdtd
				renameMember (typeConsole, "ConsoleSdtd");

				TypeDefinition typeConsoleCommand = null;

				// Rename methods in ConsoleSdtd
				md = getMethodInType (typeConsole, (method, isConstructor, retType, paramCount, paramList) => {
					return !isConstructor && paramCount == 3 && paramList [0].ParameterType.Name.Equals ("NetworkPlayer");
				}
				);
				if (md != null) {
					renameMember (md, "ExecuteCmdFromClient");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.ExecuteCmdFromClient()");
				}

			
				md = getMethodInType (typeConsole, (method, isConstructor, retType, paramCount, paramList) => {
					return !isConstructor && method.IsPublic && method.IsVirtual && retType.Name.Equals ("Void") && paramCount == 0 && method.Body.CodeSize > 20;
				}
				);
				if (md != null) {
					renameMember (md, "Run");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.Run()");
				}

			
				md = getMethodInType (typeConsole, (method, isConstructor, retType, paramCount, paramList) => {
					return !isConstructor && method.IsPublic && retType.Name.Equals ("Void") &&
						paramCount == 1 && paramList [0].ParameterType.Name.Equals ("String") && paramList [0].Name.Equals ("_line");
				}
				);
				if (md != null) {
					renameMember (md, "SendResult");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.SendResult()");
				}

			
				md = getMethodInType (typeConsole, (method, isConstructor, retType, paramCount, paramList) => {
					return !isConstructor && method.IsPrivate && retType.Name.Equals ("Void") &&
						paramCount == 2 && paramList [0].ParameterType.Name.Equals ("String") && paramList [1].ParameterType.Name.Equals ("String");
				}
				);
				if (md != null) {
					md.IsPrivate = false;
					md.IsPublic = true;
					renameMember (md, "ExecuteClientCmdInternal");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.ExecuteClientCmdInternal()");
				}

			
				md = getMethodInType (typeConsole, (method, isConstructor, retType, paramCount, paramList) => {
					return !isConstructor && method.IsPrivate && retType.Name.Equals ("Void") &&
						paramCount == 2 && paramList [0].ParameterType.Name.Equals ("String") && paramList [1].ParameterType.Name.Equals ("Boolean");
				}
				);
				if (md != null) {
					md.IsPrivate = false;
					md.IsPublic = true;
					renameMember (md, "ExecuteRemoteCmdInternal");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.ExecuteRemoteCmdInternal()");
				}

			
				// Rename fields in ConsoleSdtd
				fd = getFieldInType (typeConsole, (field, fieldType) => {
					return fieldType.FullName.Equals ("GameManager"); }
				);
				if (fd != null) {
					makeFieldPublic (fd);
					renameMember (fd, "gameManager");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.gameManager");
				}


				fd = getFieldInType (typeConsole, (field, fieldType) => {
					if (fieldType.IsGenericInstance) {
						GenericInstanceType genType = (GenericInstanceType)fieldType;
						TypeReference genRef = genType.GenericArguments [0];
						return fieldType.FullName.Contains ("Generic.List") &&
							genRef.Name.Length < 2 &&
							NameNormalizer.makeValidName (genRef.Name) != null;
					}
					return false;
				}
				);
				if (fd != null) {
					GenericInstanceType genType = (GenericInstanceType)fd.FieldType;
					TypeReference genRef = genType.GenericArguments [0];
					makeFieldPublic (fd);
					renameMember (fd, "commands");

					typeConsoleCommand = genRef.Resolve ();
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.commands");
				}


				fd = getFieldInType (typeConsole, (field, fieldType) => {
					return fieldType.Name.Equals ("NetworkPlayer"); }
				);
				if (fd != null) {
					makeFieldPublic (fd);
					renameMember (fd, "issuerOfCurrentClientCommand");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.issuerOfCurrentClientCommand");
				}


				fd = getFieldInType (typeConsole, (field, fieldType) => {
					return fieldType.Name.Equals ("NetTelnetServer"); }
				);
				if (fd != null) {
					makeFieldPublic (fd);
					renameMember (fd, "telnetServer");
				} else {
					Console.WriteLine ("FAILED: ConsoleSdtd.telnetServer");
				}


				if (typeConsoleCommand != null) {
					// Rename class ConsoleCommand
					renameMember (typeConsoleCommand, "ConsoleCommand");

					// Rename methods in ConsoleSdtd which have parameter or return type ConsoleCommand
					md = getMethodInType (typeConsole, (method, isConstructor, retType, paramCount, paramList) => {
						return !isConstructor && paramCount == 1 && paramList [0].ParameterType.FullName.Equals ("System.String") && retType.Resolve () == typeConsoleCommand; }
					);
					if (md != null) {
						renameMember (md, "getCommand");
					} else {
						Console.WriteLine ("FAILED: ConsoleSdtd.getCommand()");
					}

			
					md = getMethodInType (typeConsole, (method, isConstructor, retType, paramCount, paramList) => {
						return !isConstructor && paramCount == 1 && paramList [0].ParameterType.Resolve () == typeConsoleCommand; }
					);
					if (md != null) {
						renameMember (md, "AddCommand");
					} else {
						Console.WriteLine ("FAILED: ConsoleSdtd.AddCommand()");
					}

			
					// Rename methods in ConsoleCommand
					md = getMethodInType (typeConsoleCommand, (method, isConstructor, retType, paramCount, paramList) => {
						return !isConstructor && paramCount == 1 && paramList [0].ParameterType.Resolve () == typeConsole; }
					);
					if (md != null) {
						renameMember (md, "Help");
					} else {
						Console.WriteLine ("FAILED: ConsoleCommand.Help()");
					}

			
					md = getMethodInType (typeConsoleCommand, (method, isConstructor, retType, paramCount, paramList) => {
						return !isConstructor && paramCount == 0 && retType.Name.Equals ("Int32"); }
					);
					if (md != null) {
						renameMember (md, "RepeatInterval");
					} else {
						Console.WriteLine ("FAILED: ConsoleCommand.RepeatInterval()");
					}

			
					md = getMethodInType (typeConsoleCommand, (method, isConstructor, retType, paramCount, paramList) => {
						return !isConstructor && paramCount == 0 && retType.Name.Equals ("String[]"); }
					);
					if (md != null) {
						renameMember (md, "Names");
					} else {
						Console.WriteLine ("FAILED: ConsoleCommand.Names()");
					}

			
					md = getMethodInType (typeConsoleCommand, (method, isConstructor, retType, paramCount, paramList) => {
						return !isConstructor && paramCount == 0 && retType.Name.Equals ("String"); }
					);
					if (md != null) {
						renameMember (md, "Description");
					} else {
						Console.WriteLine ("FAILED: ConsoleCommand.Description()");
					}

			
					md = getMethodInType (typeConsoleCommand, (method, isConstructor, retType, paramCount, paramList) => {
						return !isConstructor && paramCount == 1 && paramList [0].ParameterType.IsArray; }
					);
					if (md != null) {
						renameMember (md, "Run");
					} else {
						Console.WriteLine ("FAILED: ConsoleCommand.Run()");
					}

			
				
				} else {
					Console.WriteLine ("ERROR: ConsoleCommand not found");
				}

			} else {
				Console.WriteLine ("ERROR: ConsoleSdtd not found");
			}

		}

	}
}

