using System;
using System.Collections.Generic;

public class AdminToolsStuff
{
	public static string[] GetAllowedCommandsList (AdminTools admTools, string _steamID)
	{
		List<string> allowed = new List<string> ();

		try {
			AdminToolsClientInfo tmpInfo = admTools.GetClientCommandInfo (_steamID);

			List<AdminToolsCommandPermissions> perms = admTools.commandPermissions;
			ConsoleSdtd console = CommonMappingFunctions.GetGameManager ().m_GUIConsole;

			foreach (AdminToolsCommandPermissions atcp in perms) {
				if (tmpInfo.SteamID != null && tmpInfo.SteamID.Length > 0) {
					if ((atcp.PermissionLevel >= tmpInfo.PermissionLevel) || (atcp.PermissionLevel >= 1000)) {
						addAllowed (console, allowed, atcp.Command);
					}
				} else {
					if (atcp.PermissionLevel >= 1000) {
						addAllowed (console, allowed, atcp.Command);
					}
				}
			}

			if (tmpInfo.PermissionLevel <= 0) {
				List<ConsoleCommand> commands = console.commands;
				foreach (ConsoleCommand c in commands) {
					if (!allowed.Contains (c.Names () [0])) {
						if (!hasPermissionLevel (admTools, c.Names () [0])) {
							addAllowed (console, allowed, c.Names () [0]);
						}
					}
				}
			}
		} catch (Exception e) {
			Log.Out ("Error in GetAllowedCommandsList: " + e);
		}


		return allowed.ToArray ();
	}

	private static bool hasPermissionLevel (AdminTools admTools, string cmd)
	{
		List<AdminToolsCommandPermissions> perms = admTools.commandPermissions;

		foreach (AdminToolsCommandPermissions atcp in perms) {
			foreach (string ccName in getAlternativeNames(cmd)) {
				if (atcp.Command.ToLower ().Equals (ccName)) {
					return true;
				}
			}
		}
		return false;
	}

	private static void addAllowed (ConsoleSdtd console, List<string> list, string cmd)
	{
		foreach (string ccName in getAlternativeNames(cmd)) {
			if (!list.Contains (ccName)) {
				list.Add (ccName);
			}
		}
	}

	private static string[] getAlternativeNames (string cmd)
	{
		ConsoleCommand cc = CommonMappingFunctions.GetGameManager ().m_GUIConsole.getCommand (cmd);
		if (cc != null) {
			return cc.Names ();
		} else {
			return new string[0];
		}
	}
}

