using System;
using System.Collections.Generic;

public class RemoveLandProtection : ConsoleCommand
{
	public RemoveLandProtection (ConsoleSdtd cons) : base(cons)
	{
	}

	public override string Description ()
	{
		return "removes the association of a land protection block to the owner";
	}

	public override string[] Names ()
	{
		return new string[] { "removelandprotection", "rlp" };
	}

	public override void Run (string[] _params)
	{
		try {
			if (_params.Length != 3) {
				m_Console.SendResult ("Usage: removelandprotection <x> <y> <z>");
				return;
			}

			int x = int.MinValue;
			int.TryParse (_params [0], out x);
			int y = int.MinValue;
			int.TryParse (_params [1], out y);
			int z = int.MinValue;
			int.TryParse (_params [2], out z);

			if (x == int.MinValue || y == int.MinValue || z == int.MinValue) {
				m_Console.SendResult ("At least one of the given coordinates is not a valid integer");
				return;
			}

			Vector3i v = new Vector3i (x, y, z);

			PersistentPlayerList ppl = CommonMappingFunctions.GetGameManager ().GetPersistentPlayerList ();

			Dictionary<Vector3i, PersistentPlayerData> d = ppl.positionToLPBlockOwner;
			if (d == null || !d.ContainsKey (v)) {
				m_Console.SendResult ("No land protection block at the given position or not a valid position. Use \"listlandprotection\" to get a list of keystones.");
				return;
			}

			ppl.RemoveLandProtectionBlock (v);
			ppl.Write (StaticDirectories.GetSaveGameDir () + "/players.xml");
			m_Console.SendResult ("Land protection block association at (" + v.ToString () + ") removed");
		} catch (Exception e) {
			Log.Out ("Error in RemoveLandProtection.Run: " + e);
		}
	}
}
