using System;
using System.Collections.Generic;

public class RemoveLandProtection : ConsoleCommand
{
	public RemoveLandProtection (ConsoleSdtd cons) : base(cons)
	{
	}

	public override string Description ()
	{
		return "removes the association of a land protection block to the owner";
	}

	public override string[] Names ()
	{
		return new string[] { "removelandprotection", "rlp" };
	}

	private void removeById (string _id)
	{
		try {
			PersistentPlayerList ppl = CommonMappingFunctions.GetGameManager ().GetPersistentPlayerList ();

			if (_id.Length < 1 || !ppl.Players.ContainsKey(_id)) {
				m_Console.SendResult ("Not a valid Steam ID or user has never logged on. Use \"listlandprotection\" to get a list of keystones.");
				return;
			}
			if (ppl.Players[_id].LPBlocks == null || ppl.Players[_id].LPBlocks.Count == 0) {
				m_Console.SendResult ("Player does not own any keystones. Use \"listlandprotection\" to get a list of keystones.");
				return;
			}

			List<BlockChangeInfo> changes = new List<BlockChangeInfo> ();
			foreach (Vector3i pos in ppl.Players[_id].LPBlocks) {
				BlockChangeInfo bci = new BlockChangeInfo (pos, 0, true);
				changes.Add (bci);
			}
			CommonMappingFunctions.GetGameManager ().SetBlocksRPC (changes);

			m_Console.SendResult ("#"+changes.Count + " Land protection blocks for player \"" + _id + "\" removed");
		} catch (Exception e) {
			Log.Out ("Error in RemoveLandProtection.removeById: " + e);
		}
	}

	private void removeByPosition (string[] _coords)
	{
		try {
			int x = int.MinValue;
			int.TryParse (_coords [0], out x);
			int y = int.MinValue;
			int.TryParse (_coords [1], out y);
			int z = int.MinValue;
			int.TryParse (_coords [2], out z);

			if (x == int.MinValue || y == int.MinValue || z == int.MinValue) {
				m_Console.SendResult ("At least one of the given coordinates is not a valid integer");
				return;
			}

			Vector3i v = new Vector3i (x, y, z);

			PersistentPlayerList ppl = CommonMappingFunctions.GetGameManager ().GetPersistentPlayerList ();

			Dictionary<Vector3i, PersistentPlayerData> d = ppl.positionToLPBlockOwner;
			if (d == null || !d.ContainsKey (v)) {
				m_Console.SendResult ("No land protection block at the given position or not a valid position. Use \"listlandprotection\" to get a list of keystones.");
				return;
			}

			BlockChangeInfo bci = new BlockChangeInfo (v, 0, true);

			List<BlockChangeInfo> changes = new List<BlockChangeInfo> ();
			changes.Add (bci);

			CommonMappingFunctions.GetGameManager ().SetBlocksRPC (changes);

			m_Console.SendResult ("Land protection block at (" + v.ToString () + ") removed");
		} catch (Exception e) {
			Log.Out ("Error in RemoveLandProtection.removeByPosition: " + e);
		}
	}

	public override void Run (string[] _params)
	{
		try {
			if (_params.Length == 1) {
				removeById (_params [0]);
			} else if (_params.Length == 3) {
				removeByPosition (_params);
			} else {
				m_Console.SendResult ("Usage: removelandprotection <x> <y> <z>  OR  removelandprotection <steamid>");
			}
		} catch (Exception e) {
			Log.Out ("Error in RemoveLandProtection.Run: " + e);
		}
	}
}
