using System;
using System.Collections.Generic;

public class CreativeMenu : ConsoleCommand
{
	public CreativeMenu (ConsoleSdtd cons) : base(cons)
	{
	}

	public override string Description ()
	{
		return "enable/disable creative menu";
	}

	public override string[] Names ()
	{
		return new string[] { "creativemenu", "cm" };
	}

	public override void Run (string[] _params)
	{
		try {
			if (_params.Length != 1) {
				m_Console.SendResult ("Usage: creativemenu <0/1>");
				return;
			}

			GameStats.Set (EnumGameStats.IsCreativeMenuEnabled, _params [0].Equals ("1"));

			m_Console.SendResult ("Set creative menu to " + _params [0].Equals ("1"));
		} catch (Exception e) {
			Log.Out ("Error in CreativeMenu.Run: " + e);
		}
	}
}

