using AllocsFixes.CustomCommands;
using System;
using System.Collections.Generic;

namespace AllocsFixes
{
	public class CommandExtensions
	{
		public static void InitCommandExtensions (GameManager manager)
		{
			try {
				manager.m_GUIConsole.AddCommand (new CreativeMenu (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new GetGamePrefs (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new GetTime (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new Give (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new Kill (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new ListItems (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new ListLandProtection (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new ListPlayersExtended (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new RemoveLandProtection (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new RenderMap (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new Reply (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new SayToPlayer (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new SetTimeReal (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new ShowInventory (manager.m_GUIConsole));
				manager.m_GUIConsole.AddCommand (new AllocsFixes.CustomCommands.Version (manager.m_GUIConsole));
			} catch (Exception e) {
				Log.Out ("Error registering custom commands: " + e);
			}
		}
	}
}
