using System;
using System.Collections.Generic;
using System.Threading;
using UnityEngine;

namespace AllocsFixes
{
	public class ConsoleOutputSeparator
	{
		public struct AllocsTelnetCommand
		{
			public string command;
			public AllocsTelnetConnection client;

			public AllocsTelnetCommand (string _cmd, AllocsTelnetConnection _client)
			{
				command = _cmd;
				client = _client;
			}
		}

		private static List<AllocsTelnetCommand> telnetCommandQueue = new List<AllocsTelnetCommand> ();
		private static bool isCurrentCommandFromClient = false;
		private static AllocsTelnetConnection issuerOfCurrentTelnetCommand;

		public static void C_ExecuteCmdFromClient (ConsoleSdtd console, NetworkPlayer _networkPlayer, string _playerID, string _command)
		{
			Log.Out ("Executed command \"" + _command + "\" from player \"" + _playerID + "\"");

			object obj = telnetCommandQueue;
			Monitor.Enter (obj);
			try {
				isCurrentCommandFromClient = true;
				console.issuerOfCurrentClientCommand = _networkPlayer;
				console.ExecuteClientCmdInternal (_playerID, _command);
				isCurrentCommandFromClient = false;
			} finally {
				Monitor.Exit (obj);
			}

		}

		public static void C_SendResult (ConsoleSdtd console, string _line)
		{
			if (isCurrentCommandFromClient) {
				console.gameManager.GetRPCNetworkView ().RPC ("RPC_Console", console.issuerOfCurrentClientCommand, new object[]
			{
				_line,
				false
			}
				);
			} else {
				if (console.telnetServer != null && issuerOfCurrentTelnetCommand != null)
					AllocsNetTelnetServer.WriteToClient_Single (_line, issuerOfCurrentTelnetCommand);
				else if (ControlPanel.IsStarted ())
					ControlPanel.AddTextToOutputBuffer (_line);
			}
		}

		public static void C_Run (ConsoleSdtd console)
		{
			if (telnetCommandQueue.Count > 0) {
				object obj = telnetCommandQueue;
				Monitor.Enter (obj);
				try {
					issuerOfCurrentTelnetCommand = telnetCommandQueue [0].client;
					console.ExecuteRemoteCmdInternal (telnetCommandQueue [0].command, false);
					telnetCommandQueue.RemoveAt (0);
					issuerOfCurrentTelnetCommand = null;
				} finally {
					Monitor.Exit (obj);
				}
			}
		}

		public static void QueueTelnetCommand (string _line, AllocsTelnetConnection _con)
		{
			object obj = telnetCommandQueue;
			Monitor.Enter (obj);
			try {
				telnetCommandQueue.Add (new AllocsTelnetCommand (_line, _con));
			} finally {
				Monitor.Exit (obj);
			}
		}
	}
}
