using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class ListLandProtection : ConsoleCommand
	{
		public ListLandProtection (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "lists all land protection blocks and owners";
		}

		public override string[] Names ()
		{
			return new string[] { "listlandprotection", "llp" };
		}

		public override void Run (string[] _params)
		{
			try {
				World w = CommonMappingFunctions.GetGameManager ().World;
				PersistentPlayerList ppl = CommonMappingFunctions.GetGameManager ().GetPersistentPlayerList ();

				Dictionary<Vector3i, PersistentPlayerData> d = ppl.positionToLPBlockOwner;
				if (d != null) {
					Dictionary<PersistentPlayerData, List<Vector3i>> owners = new Dictionary<PersistentPlayerData, List<Vector3i>> ();
					foreach (KeyValuePair<Vector3i, PersistentPlayerData> kvp in d) {
						if (!owners.ContainsKey (kvp.Value)) {
							owners.Add (kvp.Value, new List<Vector3i> ());
						}
						owners [kvp.Value].Add (kvp.Key);
					}

					foreach (KeyValuePair<PersistentPlayerData, List<Vector3i>> kvp in owners) {
						ClientInfo ci = CommonMappingFunctions.GetClientInfoFromEntityID (kvp.Key.EntityId);
						string name = string.Empty;
						if (ci != null) {
							name = CommonMappingFunctions.GetPlayerName (ci);
						}
						name += " (" + kvp.Key.PlayerId + ")";

						m_Console.SendResult (String.Format ("Player \"{0}\" (protected: {1}, current hardness multiplier: {2}):", name, w.LandClaimIsActive (kvp.Key), w.LandClaimPower (kvp.Key)));
						foreach (Vector3i v in kvp.Value) {
							m_Console.SendResult ("   (" + v.ToString () + ")");
						}
					}
				}

				m_Console.SendResult ("Total of " + d.Count + " keystones in the game");
			} catch (Exception e) {
				Log.Out ("Error in ListLandProtection.Run: " + e);
			}
		}
	}
}
