using AllocsFixes.MapRendering;
using System;
using System.IO;
using System.Collections.Generic;
using UnityEngine;

namespace AllocsFixes.CustomCommands
{
	public class RenderMap : ConsoleCommand
	{
		public RenderMap (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "render the current map to a file";
		}

		public override string[] Names ()
		{
			return new string[] { "rendermap", "rm" };
		}

		public override void Run (string[] _params)
		{
			try {
				AllocsFixes.MapRendering.MapRendering.Instance.RenderFullMap ();

				m_Console.SendResult ("Render map done");
			} catch (Exception e) {
				Log.Out ("Error in RenderMap.Run: " + e);
			}
		}
	}
}
