using System;
using System.Collections.Generic;

namespace AllocsFixes
{
	public class PlayerDataStuff
	{
		public class PlayerItems
		{
			public SortedList<string, int> belt = new SortedList<string, int> ();
			public SortedList<string, int> bag = new SortedList<string, int> ();

			public PlayerItems (InventoryField[] _belt, InventoryField[] _bag)
			{
				foreach (InventoryField item in _belt) {
					if (item.count > 0) {
						string name = getInvFieldName (item);
						if (belt.ContainsKey (name)) {
							belt [name] += item.count;
						} else {
							belt.Add (name, item.count);
						}
					}
				}

				foreach (InventoryField item in _bag) {
					if (item.count > 0) {
						string name = getInvFieldName (item);
						if (bag.ContainsKey (name)) {
							bag [name] += item.count;
						} else {
							bag.Add (name, item.count);
						}
					}
				}
			}
		};

		private static Dictionary<int, PlayerItems> itemsPerEntityId = new Dictionary<int, PlayerItems> ();

		public static PlayerItems GetPlayerItems (int entityId)
		{
			if (itemsPerEntityId.ContainsKey (entityId))
				return itemsPerEntityId [entityId];
			else
				return null;
		}

		public static void GM_SavePlayerData (GameManager manager, int _clientId, PlayerDataFile _playerDataFile)
		{
			try {
				int entityId = CommonMappingFunctions.GetEntityID (CommonMappingFunctions.GetClientInfoFromClientID (_clientId));
				if (entityId >= 0) {
					Log.Out ("Saving playerData for entity id: " + entityId);

					if (itemsPerEntityId.ContainsKey (entityId))
						itemsPerEntityId.Remove (entityId);
					itemsPerEntityId.Add (entityId, new PlayerItems (_playerDataFile.inventory, _playerDataFile.bag));
				}
			} catch (Exception e) {
				Log.Out ("Error in GM_SavePlayerData: " + e);
			}

//		Log.Out ("Inventory of player:");
//		for (int i = 0; i < _playerDataFile.inventory.Length; i++) {
//			InventoryField item = _playerDataFile.inventory [i];
//			printItem (item, i);
//		}
//
//		Log.Out ("Bag of player:");
//		for (int i = 0; i < _playerDataFile.bag.Length; i++) {
//			InventoryField item = _playerDataFile.bag [i];
//			printItem (item, i);
//		}
		}

		private static string getInvFieldName (InventoryField item)
		{
			ItemBase iBase = ItemBase.list [item.itemValue.type];
			string name = iBase.name;
			if (iBase.IsBlock ()) {
				ItemBlock iBlock = (ItemBlock)iBase;
				name = iBlock.GetItemName (item.itemValue);
			}
			return name;
		}

		private static void printItem (InventoryField item, int slot)
		{
			if (item.count > 0) {
				ItemBase iBase = ItemBase.list [item.itemValue.type];
				string name = iBase.name;
				if (iBase.IsBlock ()) {
					ItemBlock iBlock = (ItemBlock)iBase;
					name = iBlock.GetItemName (item.itemValue);
				}
				Log.Out (string.Format ("Slot {0:00}: {1:00} * {2}, blockinst={3}, meta={4}, type={5}, usetimes={6}",
			                        slot, item.count, name, item.itemValue.blockinst, item.itemValue.meta, item.itemValue.type, item.itemValue.usetimes)
				);
			}
		}
	}
}
