using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace AllocsFixes.NetConnections.Servers.Telnet
{
	public class Telnet : IServer
	{
		private static Thread telnetThread = null;
		private static TcpListener listener = null;
		private static bool closed = false;
		private static bool authEnabled = false;
		private static List<TelnetConnection> connections = new List<TelnetConnection> ();

		public Telnet (int port)
		{
			try {
				authEnabled = GamePrefs.GetString (EnumGamePrefs.TelnetPassword).Length != 0;
				if (authEnabled)
					listener = new TcpListener (IPAddress.Any, port);
				else
					listener = new TcpListener (IPAddress.Loopback, port);
				telnetThread = ThreadMaster.Create ("thread TelnetListenThread", new ThreadStart (telnetListenThread));
				telnetThread.Start ();
				Log.Out ("Started Telnet thread on " + port);
			} catch (Exception e) {
				Log.Out ("Error in Telnet.ctor: " + e);
			}
		}

		private void telnetListenThread ()
		{
			try {
				Log.Out ("Started thread_TelnetListenThread()");
				listener.Start ();
				while (!closed) {
					Thread.Sleep (10);
					if (listener.Pending ()) {
						TelnetConnection c = new TelnetConnection (listener.AcceptTcpClient (), authEnabled);
						connections.Add (c);
						Log.Out ("Telnet connection from: " + c.GetEndPoint ());
						if (authEnabled) {
							c.WriteLine ("Please enter password:");
						} else {
							LoginMessage (c);
						}
					}

					foreach (TelnetConnection c in connections) {
						if (c.IsClosed ()) {
							c.Close ();
							connections.Remove (c);
							break;
						}
						if (c.Read ()) {
							string line = lineCorrecter (c.GetLine ());
							if (!c.IsAuthenticated ()) {
								if (line.Equals (GamePrefs.GetString (EnumGamePrefs.TelnetPassword))) {
									c.SetAuthenticated ();
									c.WriteLine ("Logon successful.");
									c.WriteLine (string.Empty);
									c.WriteLine (string.Empty);
									c.WriteLine (string.Empty);
									LoginMessage (c);
								} else {
									c.WriteLine ("Password incorrect, please enter password:");
								}
							} else {
								if (line.ToLower ().Equals ("exit")) {
									Log.Out ("Telnet connection closed by client: " + c.GetEndPoint ());
									c.Close ();
									connections.Remove (c);
									break;
								}
								Log.Out ("Telnet executed \"" + line + "\" from: " + c.GetEndPoint ());
								ConsoleOutputSeparator.QueueNetCommand (line, c);
							}
						}
					}
				}
				Log.Out ("Exited thread_TelnetListenThread()");
				ThreadMaster.Remove (Thread.CurrentThread.Name);
			} catch (Exception ex) {
				Log.Out ("Error in TelnetListenThread: " + ex.Message);
				Log.Out ("Stack Trace: " + ex.StackTrace);
			}
		}

		private void LoginMessage (TelnetConnection c)
		{
			c.WriteLine ("*** Connected with 7DTD server.");
			c.WriteLine ("*** Dedicated server only build");
			c.WriteLine ("*** Allocs server fixes loaded");
			c.WriteLine (string.Empty);
			c.WriteLine ("Server IP:   " + 
				((GamePrefs.GetString (EnumGamePrefs.ServerIP) != null && GamePrefs.GetString (EnumGamePrefs.ServerIP).Length != 0) ? GamePrefs.GetString (EnumGamePrefs.ServerIP) : "Any")
			);
			c.WriteLine ("Server port: " + GamePrefs.GetInt (EnumGamePrefs.ServerPort));
			c.WriteLine ("Max players: " + GamePrefs.GetInt (EnumGamePrefs.ServerMaxPlayerCount));
			c.WriteLine ("Game mode:   " + GamePrefs.GetString (EnumGamePrefs.GameMode));
			c.WriteLine ("World:       " + GamePrefs.GetString (EnumGamePrefs.GameWorld));
			c.WriteLine ("Game name:   " + GamePrefs.GetString (EnumGamePrefs.GameName));
			c.WriteLine ("Difficulty:  " + GamePrefs.GetInt (EnumGamePrefs.GameDifficulty));
			c.WriteLine (string.Empty);
			c.WriteLine ("Press 'help' to get a list of all commands. Press 'exit' to end session.");
			c.WriteLine (string.Empty);
		}

		private string lineCorrecter (string line)
		{
			string res = "";
			for (int i = 0; i < line.Length; i++) {
				if (line [i] >= ' ' && line [i] != '\'' && line [i] <= '~') {
					res += line [i];
				}
			}
			return res.Trim ();
		}

		public void Disconnect ()
		{
			try {
				closed = true;
				if (listener != null) {
					listener.Stop ();
				}
				foreach (TelnetConnection c in connections) {
					c.Close ();
				}
				Thread.Sleep (100);
			} catch (Exception e) {
				Log.Out ("Error in Telnet.Disconnect: " + e);
			}
		}

		private void RemoveClosedConnections ()
		{
			try {
				foreach (TelnetConnection c in connections) {
					if (c.IsClosed ()) {
						c.Close ();
					}
				}
			} catch (Exception e) {
				Log.Out ("Error in Telnet.RemoveClosedConnections: " + e);
			}
		}

		public void WriteToClient (string line)
		{
			if (line == null) {
				return;
			}
			RemoveClosedConnections ();
			foreach (TelnetConnection c in connections) {
				if (c.IsAuthenticated ())
					c.WriteLine (line);
			}
		}

		public void WriteToClient_Single (string line, IConnection client)
		{
			if (line == null) {
				return;
			}
			RemoveClosedConnections ();
			foreach (TelnetConnection con in connections) {
				if (con == client) {
					if (con.IsAuthenticated ())
						con.WriteLine (line);
				}
			}
		}

	}
}

