using System;
using System.Collections.Generic;
using System.Threading;
using UnityEngine;

namespace AllocsFixes.NetConnections
{
	public class ConsoleOutputSeparator
	{
		public struct NetCommand
		{
			public string command;
			public IConnection client;

			public NetCommand (string _cmd, IConnection _client)
			{
				command = _cmd;
				client = _client;
			}
		}

		private static List<NetCommand> netCommandQueue = new List<NetCommand> ();
		private static bool isCurrentCommandFromClient = false;
		private static IConnection issuerOfCurrentCommand;

		public static void C_ExecuteCmdFromClient (ConsoleSdtd console, NetworkPlayer _networkPlayer, string _playerID, string _command)
		{
			Log.Out ("Executed command \"" + _command + "\" from player \"" + _playerID + "\"");

			object obj = netCommandQueue;
			Monitor.Enter (obj);
			try {
				isCurrentCommandFromClient = true;
				console.issuerOfCurrentClientCommand = _networkPlayer;
				console.ExecuteClientCmdInternal (_playerID, _command);
				isCurrentCommandFromClient = false;
			} finally {
				Monitor.Exit (obj);
			}

		}

		public static void C_SendResult (ConsoleSdtd console, string _line)
		{
			if (isCurrentCommandFromClient) {
				console.gameManager.GetRPCNetworkView ().RPC ("RPC_Console", console.issuerOfCurrentClientCommand, new object[]
			{
				_line,
				false
			}
				);
			} else {
				if (console.telnetServer != null && issuerOfCurrentCommand != null)
					NetTelnetServer.WriteToClient_Single (_line, issuerOfCurrentCommand);
				else if (ControlPanel.IsStarted ())
					ControlPanel.AddTextToOutputBuffer (_line);
			}
		}

		public static void C_Run (ConsoleSdtd console)
		{
			if (netCommandQueue.Count > 0) {
				object obj = netCommandQueue;
				Monitor.Enter (obj);
				try {
					issuerOfCurrentCommand = netCommandQueue [0].client;
					console.ExecuteRemoteCmdInternal (netCommandQueue [0].command, false);
					netCommandQueue.RemoveAt (0);
					issuerOfCurrentCommand = null;
				} finally {
					Monitor.Exit (obj);
				}
			}
		}

		public static void QueueNetCommand (string _line, IConnection _con)
		{
			object obj = netCommandQueue;
			Monitor.Enter (obj);
			try {
				netCommandQueue.Add (new NetCommand (_line, _con));
			} finally {
				Monitor.Exit (obj);
			}
		}
	}
}
