using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Reflection;
using System.Threading;
using UnityEngine;

namespace AllocsFixes.NetConnections
{
	public class NetTelnetServer
	{
		private static List<IServer> servers = new List<IServer> ();

		public static void init (int port)
		{
			try {
				Log.Out ("[7dtd-server-fixes by Alloc] Version: " + Assembly.GetExecutingAssembly ().GetName ().Version);
				servers.Add (new Servers.Telnet.Telnet (port));

				int webPort = GamePrefs.GetInt (EnumGamePrefs.ControlPanelPort);
				if (GamePrefs.GetBool (EnumGamePrefs.ControlPanelEnabled) && webPort > 0 && webPort < 65534) {
					if (Directory.Exists (Application.dataPath + "/../webserver")) {
						servers.Add (new Servers.Web.Web (webPort + 2));
					}
				}
			} catch (Exception e) {
				Log.Out ("Error in NetTelnetServer.init: " + e);
			}
		}

		public static void SetConsole (ConsoleSdtd console)
		{
		}

		public static void Disconnect ()
		{
			foreach (IServer s in servers)
				s.Disconnect ();
		}

		public static void WriteToClient (string line)
		{
			if (line == null) {
				return;
			}
			foreach (IServer s in servers)
				s.WriteToClient (line);
		}

		public static void WriteToClient_Single (string line, IConnection client)
		{
			if (line == null) {
				return;
			}
			foreach (IServer s in servers)
				s.WriteToClient_Single (line, client);
		}
	}
}
