using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class EnableRendering : ConsoleCommand
	{
		public EnableRendering (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "enable/disable live map rendering";
		}

		public override string[] Names ()
		{
			return new string[] { "enablerendering", string.Empty };
		}

		public override void Run (string[] _params)
		{
			try {
				if (_params.Length != 1) {
					m_Console.SendResult ("Current state: " + AllocsFixes.MapRendering.MapRendering.renderingEnabled);
					return;
				}

				AllocsFixes.MapRendering.MapRendering.renderingEnabled = _params[0].Equals("1");
				m_Console.SendResult ("Set live map rendering to " + _params [0].Equals ("1"));
			} catch (Exception e) {
				Log.Out ("Error in EnableRendering.Run: " + e);
			}
		}
	}
}