using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace AllocsFixes.PersistentData
{
	[Serializable()]
	public class PersistentContainer : ISerializable
	{
		public Dictionary<string, KnownPlayers> players = new Dictionary<string, KnownPlayers> ();
		private static PersistentContainer instance;

		public static PersistentContainer Instance {
			get {
				if (instance == null) {
					instance = new PersistentContainer ();
				}
				return instance;
			}
		}

		private PersistentContainer ()
		{
			Log.Out ("new PersistentContainer()");
		}

		public void Save ()
		{
			Stream stream = File.Open (StaticDirectories.GetSaveGameDir () + "/AllocsPeristentData.bin", FileMode.Create);
			BinaryFormatter bFormatter = new BinaryFormatter ();
			bFormatter.Serialize (stream, this);
			stream.Close ();
		}

		public static bool Load ()
		{
			if (File.Exists (StaticDirectories.GetSaveGameDir () + "/AllocsPeristentData.bin")) {
				PersistentContainer obj;
				Stream stream = File.Open (StaticDirectories.GetSaveGameDir () + "/AllocsPeristentData.bin", FileMode.Open);
				BinaryFormatter bFormatter = new BinaryFormatter ();
				obj = (PersistentContainer)bFormatter.Deserialize (stream);
				stream.Close ();
				instance = obj;
				return true;
			} else
				return false;
		}

		public PersistentContainer (SerializationInfo info, StreamingContext ctxt)
		{
			this.players = (Dictionary<string, KnownPlayers>)info.GetValue ("players", typeof(Dictionary<string, KnownPlayers>));
		}

		public void GetObjectData (SerializationInfo info, StreamingContext context)
		{
			info.AddValue ("players", this.players);
		}

	}
}

