using System;
using System.Runtime.Serialization;
using UnityEngine;

namespace AllocsFixes.PersistentData
{
	[Serializable]
	public class Player
	{
		private readonly string steamId;
		private int entityId;
		private string name;
		private string ip;
		private long totalPlayTime;
		private Inventory inventory;
		[NonSerialized]
		private ClientInfo
			clientInfo;

		public string SteamID {
			get { return steamId; }
		}

		public int EntityID {
			get { return entityId; }
			set { entityId = value; }
		}

		public string Name {
			get { return name; }
			set { name = value; }
		}

		public string IP {
			get { return ip; }
			set { ip = value; }
		}

		public Inventory Inventory {
			get {
				if (inventory == null)
					inventory = new Inventory ();
				return inventory;
			}
		}

		public bool IsOnline {
			get { return clientInfo != null; }
		}

		public ClientInfo ClientInfo {
			get { return clientInfo; }
		}

		public EntityPlayer Entity {
			get {
				if (IsOnline) {
					return CommonMappingFunctions.GetEntityPlayer (clientInfo);
				} else {
					return null;
				}
			}
		}

		public long TotalPlayTime {
			get {
				if (IsOnline) {
					return totalPlayTime + (long)(Time.timeSinceLevelLoad - Entity.CreationTimeSinceLevelLoad);
				} else {
					return totalPlayTime;
				}
			}
		}

		public void SetOffline ()
		{
			Log.Out ("Player set to offline: " + steamId);
			totalPlayTime += (long)(Time.timeSinceLevelLoad - Entity.CreationTimeSinceLevelLoad);
			clientInfo = null;
		}

		public void SetOnline (ClientInfo ci)
		{
			Log.Out ("Player set to online: " + steamId);
			clientInfo = ci;
			entityId = CommonMappingFunctions.GetEntityID (ci);
			name = CommonMappingFunctions.GetPlayerName (ci);
			ip = ci.networkPlayer.ipAddress;
		}

		public Player (string steamId)
		{
			this.steamId = steamId;
			this.inventory = new Inventory ();
		}


	}
}
