using System;

namespace AllocsFixes
{
	public class StateManager
	{
		public static void Awake (GameManager manager)
		{
			try {
				CommandExtensions.InitCommandExtensions (manager);
				PersistentData.PersistentContainer.Load ();
			} catch (Exception e) {
				Log.Out ("Error in StateManager.Awake: " + e);
			}
		}

		public static void Shutdown (GameManager manager)
		{
			try {
				PersistentData.PersistentContainer.Instance.Save ();
			} catch (Exception e) {
				Log.Out ("Error in StateManager.Shutdown: " + e);
			}
		}
	}
}

