using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using UnityEngine;

namespace AllocsFixes
{
	public class AllocsLogFunctions
	{
		public static void RequestToSpawnPlayer (GameManager manager, int _clientId, string _name, string _playerClassname, string _skinTexture, int _chunkViewDim)
		{
			try {
				ClientInfo ci = CommonMappingFunctions.GetClientInfoFromClientID (_clientId);
				int entityId = CommonMappingFunctions.GetEntityID (ci);
				EntityPlayer ep = CommonMappingFunctions.GetEntityPlayer (ci);
				string steamId = CommonMappingFunctions.GetSteamID (ci);

				string ip = ci.networkPlayer.ipAddress;
				string name = string.Empty;

				if (ep != null)
					name = ep.EntityName;

				Log.Out ("Player connected, clientid=" + _clientId +
					", entityid=" + entityId +
					", name=" + name +
					", steamid=" + steamId +
					", ip=" + ip
				);

				PersistentContainer.Instance.Players[steamId].SetOnline(ci);
			} catch (Exception e) {
				Log.Out ("Error in AllocsLogFunctions.RequestToSpawnPlayer: " + e);
			}
		}

		public static void PlayerDisconnected (GameManager manager, int _clientId) {
			try {
				ClientInfo ci = CommonMappingFunctions.GetClientInfoFromClientID (_clientId);
				string steamId = CommonMappingFunctions.GetSteamID (ci);
				Players players = PersistentContainer.Instance.Players;
				if (players.SteamIDs.Contains(steamId))
					players[steamId].SetOffline();
			} catch (Exception e) {
				Log.Out ("Error in AllocsLogFunctions.PlayerDisconnected: " + e);
			}
		}
	}
}
