using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Threading;

namespace AllocsFixes.PersistentData
{
	[Serializable]
	public class Inventory
	{
		public List<InvItem> bag;
		public List<InvItem> belt;

		public Inventory ()
		{
			bag = new List<InvItem> ();
			belt = new List<InvItem> ();
		}

		public void Update (PlayerDataFile pdf)
		{
			Log.Out ("Updating player inventory - player id: " + pdf.id);
			ProcessInv (bag, pdf.bag);
			ProcessInv (belt, pdf.inventory);
		}

		private void ProcessInv (List<InvItem> target, InventoryField[] sourceFields)
		{
			Monitor.Enter (target);
			try {
				target.Clear ();
				for (int i = 0; i < sourceFields.Length; i++) {
					if (sourceFields [i].count > 0) {
						int count = sourceFields [i].count;
						string name = getInvFieldName (sourceFields [i]);

						target.Add (new InvItem (name, count));
					} else {
						target.Add (null);
					}
				}
			} finally {
				Monitor.Exit (target);
			}
		}

		private string getInvFieldName (InventoryField item)
		{
			ItemBase iBase = ItemBase.list [item.itemValue.type];
			string name = iBase.name;
			if (iBase.IsBlock ()) {
				ItemBlock iBlock = (ItemBlock)iBase;
				name = iBlock.GetItemName (item.itemValue);
			}
			return name;
		}


	}
}

