using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class ListLandProtection : ConsoleCommand
	{
		public ListLandProtection (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "lists all land protection blocks and owners";
		}

		public override string[] Names ()
		{
			return new string[] { "listlandprotection", "llp" };
		}

		public override void Run (string[] _params)
		{
			try {
				World w = CommonMappingFunctions.GetGameManager ().World;
				PersistentPlayerList ppl = CommonMappingFunctions.GetGameManager ().GetPersistentPlayerList ();

				bool summaryOnly = false;
				string steamIdFilter = string.Empty;

				if (_params.Length == 1) {
					long tempLong;

					if (_params [0].ToLower ().Equals ("summary")) {
						summaryOnly = true;
					} else if (_params [0].Length == 17 && long.TryParse (_params [0], out tempLong)) {
						steamIdFilter = _params [0];
					} else {
						ClientInfo ci = CommonMappingFunctions.GetClientInfoFromNameOrID (_params [0], true);
						if (ci != null) {
							steamIdFilter = CommonMappingFunctions.GetSteamID (ci);
						} else {
							m_Console.SendResult ("Player name or entity id \"" + _params [0] + "\" not found.");
							return;
						}
					}
				}

				Dictionary<Vector3i, PersistentPlayerData> d = ppl.positionToLPBlockOwner;
				if (d != null) {
					Dictionary<PersistentPlayerData, List<Vector3i>> owners = new Dictionary<PersistentPlayerData, List<Vector3i>> ();
					foreach (KeyValuePair<Vector3i, PersistentPlayerData> kvp in d) {
						if (!owners.ContainsKey (kvp.Value)) {
							owners.Add (kvp.Value, new List<Vector3i> ());
						}
						owners [kvp.Value].Add (kvp.Key);
					}

					foreach (KeyValuePair<PersistentPlayerData, List<Vector3i>> kvp in owners) {
						if (steamIdFilter.Length == 0 || kvp.Key.PlayerId.Equals (steamIdFilter)) {
							string name = PersistentData.PersistentContainer.Instance.Players[kvp.Key.PlayerId].Name;
							name += " (" + kvp.Key.PlayerId + ")";

							m_Console.SendResult (String.Format ("Player \"{0}\" owns {3} keystones (protected: {1}, current hardness multiplier: {2})", name, w.LandClaimIsActive (kvp.Key), w.LandClaimPower (kvp.Key), kvp.Value.Count));
							if (!summaryOnly) {
								foreach (Vector3i v in kvp.Value) {
									m_Console.SendResult ("   (" + v.ToString () + ")");
								}
							}
						}
					}
				}

				if (steamIdFilter.Length == 0)
					m_Console.SendResult ("Total of " + d.Count + " keystones in the game");
			} catch (Exception e) {
				Log.Out ("Error in ListLandProtection.Run: " + e);
			}
		}
	}
}
