SDTD_Projection = {
	project: function (latlng) {
		return new L.Point(latlng.lng / 16, latlng.lat / 16);
	},

	unproject: function (point) {
		return new L.LatLng(point.y * 16, point.x * 16);
	}
};

SDTD_CRS = L.extend({}, L.CRS.Simple, {
	projection: SDTD_Projection,
	transformation: new L.Transformation(1, 0, -1, 0),

	scale: function (zoom) {
		return Math.pow(2, zoom);
	}
});

var CoordToChunk = function(latlng) {
	var x = Math.floor(((latlng.lng + 16777216) / 16) - (16777216 / 16));
	var y = Math.floor(((latlng.lat + 16777216) / 16) - (16777216 / 16));
	return L.latLng(y, x);
}

var CoordToRegion = function(latlng) {
	var x = Math.floor(((latlng.lng + 16777216) / 512) - (16777216 / 512));
	var y = Math.floor(((latlng.lat + 16777216) / 512) - (16777216 / 512));
	return L.latLng(y, x);
}

var FormatCoord = function(latlng) {
	return Math.abs(latlng.lat)+ (latlng.lat>=0 ? " N" : " S") + " / " + Math.abs(latlng.lng) + (latlng.lng>=0 ? " E" : " W");
}

var map = L.map('map', {
	zoomControl: true,
	attributionControl: false,
	crs: SDTD_CRS
}).setView([0, 0], 0);

L.tileLayer('../../map/{z}/{x}/{y}.png?t={time}', {
	maxZoom: 5,
	minZoom: 0,
	maxNativeZoom: 4,
	tileSize: 128,
	continuousWorld: true,
	tms: true,
	unloadInvisibleTiles: true,
	time: function() { return new Date().getTime(); }
}).addTo(map);


map.on('mousemove', function(e) {
	var rf = CoordToRegion(e.latlng);
	L.DomUtil.get('pos').textContent = FormatCoord(e.latlng);
	L.DomUtil.get('regfile').textContent = "r." + rf.lng + "." + rf.lat + ".7rg";
});
