#!/bin/bash
# Version 3
. /etc/7dtd.conf

DT=`date "+%Y-%m-%d_%H-%M"`
NewBackup=$SDTD_BACKUP_ROOT/$DT

# Check for backup folder existence
if [ -e $SDTD_BACKUP_ROOT ]; then
	# Exists, copy(link) latest backup
	unset -v LatestBackup
	for file in "$SDTD_BACKUP_ROOT"/*; do
		[[ $file -nt $LatestBackup ]] && LatestBackup=$file
	done
	$CP -al $LatestBackup $NewBackup
else
	# Create new backup dir
	mkdir $SDTD_BACKUP_ROOT
fi

$RSYNC -a --delete --numeric-ids --delete-excluded $SDTD_BASE/instances/./ $NewBackup
touch $NewBackup

#echo "Backup folder disk usage: `$DU -sh $SDTD_BACKUP_ROOT`"
