using System;
using System.Collections.Generic;
using System.Text;

namespace AllocsFixes.JSON
{
	public class JSONObject : JSONNode
	{
		private Dictionary<string, JSONNode> nodes = new Dictionary<string, JSONNode> ();

		public void Add (string name, JSONNode node)
		{
			nodes.Add (name, node);
		}

		public override string ToString ()
		{
			StringBuilder sb = new StringBuilder ("{");
			foreach (KeyValuePair<string, JSONNode> kvp in nodes) {
				sb.Append (String.Format ("\"{0}\":", kvp.Key));
				sb.Append (kvp.Value.ToString ());
				sb.Append (",");
			}
			if (sb.Length > 1)
				sb.Remove (sb.Length - 1, 1);
			sb.Append ("}");
			return sb.ToString ();
		}

	}
}

