using System;
using System.Collections.Generic;
using System.Text;

namespace AllocsFixes.JSON
{
	public class JSONArray : JSONNode
	{
		private List<JSONNode> nodes = new List<JSONNode> ();

		public void Add (JSONNode node)
		{
			nodes.Add(node);
		}

		public override string ToString ()
		{
			StringBuilder sb = new StringBuilder ("[");
			foreach (JSONNode n in nodes) {
				sb.Append (n.ToString ());
				sb.Append (",");
			}
			if (sb.Length > 1)
				sb.Remove (sb.Length - 1, 1);
			sb.Append ("]");
			return sb.ToString ();
		}

	}
}

