using System;
using System.Text;

namespace AllocsFixes.JSON
{
	public class JSONString : JSONNode
	{
		private string value;

		public JSONString (string value)
		{
			this.value = value;
		}

		public override string ToString ()
		{
			if (value == null || value.Length == 0) {
				return "";
			}

			int len = value.Length;

			StringBuilder sb = new StringBuilder (len + 4);
			String t;

			foreach (char c in value) {
				switch (c) {
					case '\\':
					case '"':
					case '/':
						sb.Append ('\\');
						sb.Append (c);
						break;
					case '\b':
						sb.Append ("\\b");
						break;
					case '\t':
						sb.Append ("\\t");
						break;
					case '\n':
						sb.Append ("\\n");
						break;
					case '\f':
						sb.Append ("\\f");
						break;
					case '\r':
						sb.Append ("\\r");
						break;
					default:
						if (c < ' ') {
							t = "000" + String.Format ("X", c);
							sb.Append ("\\u" + t.Substring (t.Length - 4));
						} else {
							sb.Append (c);
						}
						break;
				}
			}

			return string.Format ("\"{0}\"", sb.ToString ());
		}

	}
}

