using AllocsFixes.CustomCommands;
using System;
using System.Collections.Generic;

namespace AllocsFixes
{
	public class CommandExtensions
	{
		public static void InitCommandExtensions (GameManager manager)
		{
			try {
				ConsoleSdtd cons = manager.m_GUIConsole;
				cons.AddCommand (new CreativeMenu (cons));
				cons.AddCommand (new EnableRendering (cons));
				cons.AddCommand (new GetGamePrefs (cons));
				cons.AddCommand (new GetTime (cons));
				cons.AddCommand (new Give (cons));
				cons.AddCommand (new Kill (cons));
				cons.AddCommand (new ListItems (cons));
				cons.AddCommand (new ListKnownPlayers (cons));
				cons.AddCommand (new ListLandProtection (cons));
				cons.AddCommand (new ListPlayersExtended (cons));
				cons.AddCommand (new RemoveLandProtection (cons));
				cons.AddCommand (new RenderMap (cons));
				cons.AddCommand (new Reply (cons));
				cons.AddCommand (new SayToPlayer (cons));
				cons.AddCommand (new SetTimeReal (cons));
				cons.AddCommand (new ShowInventory (cons));
				cons.AddCommand (new TeleportPlayer (cons));
				cons.AddCommand (new AllocsFixes.CustomCommands.Version (cons));
			} catch (Exception e) {
				Log.Out ("Error registering custom commands: " + e);
			}
		}
	}
}
