using AllocsFixes.NetConnections.Servers.Web.API;
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Threading;

namespace AllocsFixes.NetConnections.Servers.Web
{
	public class ApiHandler : PathHandler
	{
		private string staticPart;
		private Dictionary<String, WebAPI> apis = new Dictionary<string, WebAPI> ();

		public ApiHandler (string staticPart)
		{
			this.staticPart = staticPart;
			apis.Add ("getplayersonline", new GetPlayersOnline ());
			apis.Add ("getplayerslocation", new GetPlayersLocation ());
			apis.Add ("getplayerinventory", new GetPlayerInventory ());
		}

		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, HttpListenerBasicIdentity user)
		{
			string apiName = req.Url.AbsolutePath.Remove (0, staticPart.Length);
			if (!AuthorizeForCommand (apiName, user)) {
				resp.StatusCode = (int)HttpStatusCode.Forbidden;
			} else {
				foreach (KeyValuePair<string, WebAPI> kvp in apis) {
					try {
						if (apiName.StartsWith (kvp.Key)) {
							kvp.Value.HandleRequest (req, resp, user);
							return;
						}
					} catch (Exception e) {
						Log.Out ("Error in ApiHandler.HandleRequest(): Handler threw an exception: " + e);
						resp.StatusCode = (int)HttpStatusCode.InternalServerError;
						return;
					}
				}
			}
	
			Log.Out ("Error in ApiHandler.HandleRequest(): No handler found for API \"" + apiName + "\"");
			resp.StatusCode = (int)HttpStatusCode.NotFound;
		}

		private bool AuthorizeForCommand (string apiName, HttpListenerBasicIdentity user)
		{
			return true;
		}

	}

}

