#!/bin/bash
# Version 4

# Backups game data files.

sdtdCommandBackup() {
	DT=`date "+%Y-%m-%d_%H-%M"`
	NewBackup=$SDTD_BACKUP_ROOT/$DT

	# Check for backup folder existence
	if [ -e $SDTD_BACKUP_ROOT ]; then
		# Exists, copy(link) latest backup
		unset -v LatestBackup
		for file in "$SDTD_BACKUP_ROOT"/*; do
			[[ $file -nt $LatestBackup ]] && LatestBackup=$file
		done
		cp -al $LatestBackup $NewBackup
	else
		# Create new backup dir
		mkdir $SDTD_BACKUP_ROOT
	fi

	$RSYNC -a --delete --numeric-ids --delete-excluded $SDTD_BASE/instances/./ $NewBackup
	touch $NewBackup

	#echo "Backup folder disk usage: `$DU -sh $SDTD_BACKUP_ROOT`"
}

sdtdCommandBackupHelp() {
	echo "Usage: $(basename $0) backup"
	echo
	echo "Backups all data files (instance configurations, save data, logs)."
}

sdtdCommandBackupDescription() {
	echo "Backup game data files"
}
