#!/bin/bash
# Version 4


sdtdCommandInstances() {
	printf "%-*s | %-*s | %-*s | %-*s\n" 20 "Instance name" 8 "Running" 7 "Players" 5 "Port"
	printf -v line "%*s-+-%*s-+-%*s-+-%*s\n" 20 " " 8 " " 7 " " 5 " "
	echo ${line// /-}
	for I in $(getInstanceList); do
		if [ $(isRunning $I) -eq 1 ]; then
			run="yes"
			tel=$(telnetCommand $I lp)
			cur=`echo $tel | sed "s/\r/\n/g" | sed "s/^ //g" | grep "Total of " | cut -d\  -f 3`
		else
			run="no"
			cur="-"
		fi

		max=$(getConfigValue $I ServerMaxPlayerCount)
		port=$(getConfigValue $I ServerPort)

		printf "%-*s | %*s |   %2s/%2d | %5d\n" 20 "$I" 8 "$run" $cur $max $port
	done
	exit 0
}

sdtdCommandInstancesHelp() {
	echo "Usage: $(basename $0) instances"
	echo
	echo "List all defined instances and their status."
}

sdtdCommandInstancesDescription() {
	echo "List all defined instances"
}
