using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class TeleportPlayer : ConsoleCommand
	{
		public TeleportPlayer (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "teleport a player to a given location";
		}

		public override string[] Names ()
		{
			return new string[] { "teleportplayer", "tele" };
		}

		public override void Run (string[] _params)
		{
			try {
				if (_params.Length != 4) {
					m_Console.SendResult ("Usage: teleportplayer <entityid|playername|steamid> <x> <y> <z>");
				} else {
					string steamid = PersistentContainer.Instance.Players.GetSteamID (_params [0], true);
					if (steamid == null) {
						m_Console.SendResult ("Playername or entity/steamid id not found.");
						return;
					}

					Player p = PersistentContainer.Instance.Players [steamid];
					if (!p.IsOnline) {
						m_Console.SendResult ("Player not online.");
						return;
					}

					int x = int.MinValue;
					int.TryParse (_params [1], out x);
					int y = int.MinValue;
					int.TryParse (_params [2], out y);
					int z = int.MinValue;
					int.TryParse (_params [3], out z);

					if (x == int.MinValue || y == int.MinValue || z == int.MinValue) {
						m_Console.SendResult ("At least one of the given coordinates is not a valid integer");
						return;
					}

					p.Entity.position.x = x;
					p.Entity.position.y = y;
					p.Entity.position.z = z;
					NetPackage_EntityPosAndRot pkg = new NetPackage_EntityPosAndRot (p.Entity);

					p.ClientInfo.netConnection [0].Send (pkg);
				}
			} catch (Exception e) {
				Log.Out ("Error in TeleportPlayer.Run: " + e);
			}
		}

	}
}
