using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace AllocsFixes.NetConnections.Servers.Telnet
{
	public class Telnet : IServer
	{
		private Thread telnetThread = null;
		private TcpListener listener = null;
		private bool closed = false;
		private bool authEnabled = false;
		private List<TelnetConnection> connections = new List<TelnetConnection> ();

		public Telnet ()
		{
			try {
				if (!GamePrefs.GetBool (EnumGamePrefs.TelnetEnabled)) {
					return;
				}

				int port = GamePrefs.GetInt (EnumGamePrefs.TelnetPort);

				authEnabled = GamePrefs.GetString (EnumGamePrefs.TelnetPassword).Length != 0;
				if (authEnabled)
					listener = new TcpListener (IPAddress.Any, port);
				else
					listener = new TcpListener (IPAddress.Loopback, port);
				telnetThread = ThreadMaster.Create ("thread TelnetListenThread", new ThreadStart (telnetListenThread));
				telnetThread.Start ();

				NetTelnetServer.RegisterServer (this);

				Log.Out ("Started Telnet on " + port);
			} catch (Exception e) {
				Log.Out ("Error in Telnet.ctor: " + e);
			}
		}

		private void telnetListenThread ()
		{
			try {
				listener.Start ();
				try {
					while (!closed) {
						TelnetConnection c = new TelnetConnection (listener.AcceptTcpClient (), authEnabled);
						connections.Add (c);
					}
				} catch (SocketException) {
				} catch (ThreadInterruptedException) {
				}
				ThreadMaster.Remove (Thread.CurrentThread.Name);
			} catch (Exception ex) {
				Log.Out ("Error in TelnetListenThread: " + ex);
			}
		}

		public void Disconnect ()
		{
			try {
				closed = true;
				if (listener != null) {
					listener.Stop ();
					listener = null;
				}
				foreach (TelnetConnection c in connections) {
					c.Close ();
				}
				Thread.Sleep (100);
				if (telnetThread != null) {
					telnetThread.Interrupt ();
				}
			} catch (Exception e) {
				Log.Out ("Error in Telnet.Disconnect: " + e);
			}
		}

		private void RemoveClosedConnections ()
		{
			try {
				List<TelnetConnection> toRemove = new List<TelnetConnection> ();
				foreach (TelnetConnection c in connections) {
					if (c.IsClosed ())
						toRemove.Add (c);
				}
				foreach (TelnetConnection c in toRemove) {
					connections.Remove (c);
				}
			} catch (Exception e) {
				Log.Out ("Error in Telnet.RemoveClosedConnections: " + e);
			}
		}

		public void WriteToClient (string line)
		{
			if (line == null) {
				return;
			}
			RemoveClosedConnections ();
			foreach (TelnetConnection c in connections) {
				if (c.IsAuthenticated ())
					c.WriteLine (line);
			}
		}

		public void WriteToClient_Single (string line, IConnection client)
		{
			if (line == null) {
				return;
			}
			RemoveClosedConnections ();
			foreach (TelnetConnection con in connections) {
				if (con == client) {
					if (con.IsAuthenticated ())
						con.WriteLine (line);
				}
			}
		}

	}
}

