using AllocsFixes.NetConnections.Servers.Telnet;
using AllocsFixes.NetConnections.Servers.Web;
using System;
using System.Reflection;

namespace AllocsFixes
{
	public class StateManager
	{
		public static void Awake (GameManager manager)
		{
			try {
				Log.Out ("[7dtd-server-fixes by Alloc] Version: " + Assembly.GetExecutingAssembly ().GetName ().Version);
				new Web();
				new Telnet();

				CommandExtensions.InitCommandExtensions (manager);

				PersistentData.PersistentContainer.Load ();
			} catch (Exception e) {
				Log.Out ("Error in StateManager.Awake: " + e);
			}
		}

		public static void Shutdown (GameManager manager)
		{
			try {
				Log.Out ("Server shutting down!");
				PersistentData.PersistentContainer.Instance.Save ();
			} catch (Exception e) {
				Log.Out ("Error in StateManager.Shutdown: " + e);
			}
		}
	}
}

