using System;
using System.Collections.Generic;
using System.Threading;

namespace AllocsFixes
{
	public class BlockingQueue<T>
	{
		private Queue<T> queue = new Queue<T> ();

		public void Enqueue (T item)
		{
			lock (queue) {
				queue.Enqueue (item);
				Monitor.PulseAll (queue);
			}
		}

		public T Dequeue ()
		{
			lock (queue) {
				while (queue.Count == 0) {
					Monitor.Wait (queue);
				}
				return queue.Dequeue ();
			}
		}


	}
}

