using System;
using System.Collections.Generic;
using System.Threading;
using UnityEngine;

namespace AllocsFixes.NetConnections
{
	public class ConsoleOutputSeparator
	{
		public struct NetCommand
		{
			public string command;
			public IConnection client;

			public NetCommand (string _cmd, IConnection _client)
			{
				command = _cmd;
				client = _client;
			}
		}

		private static List<NetCommand> netCommandQueue = new List<NetCommand> ();
		private static bool isCurrentCommandFromClient = false;
		private static IConnection issuerOfCurrentCommand;

		public static void C_ExecuteCmdFromClient (ConsoleSdtd console, NetworkPlayer _networkPlayer, string _playerID, string _command)
		{
			Log.Out ("Executed command \"" + _command + "\" from player \"" + _playerID + "\"");

			lock (netCommandQueue) {
				isCurrentCommandFromClient = true;
				console.issuerOfCurrentClientCommand = _networkPlayer;
				console.ExecuteClientCmdInternal (_playerID, _command);
				isCurrentCommandFromClient = false;
			}

		}

		public static void C_SendResult (ConsoleSdtd console, string _line)
		{
			if (isCurrentCommandFromClient) {
				console.gameManager.GetRPCNetworkView ().RPC ("RPC_Console", console.issuerOfCurrentClientCommand, new object[]
			{
				_line,
				false
			}
				);
			} else {
				if (console.telnetServer != null && issuerOfCurrentCommand != null)
					issuerOfCurrentCommand.SendLine (_line);
				else if (ControlPanel.IsStarted ())
					ControlPanel.AddTextToOutputBuffer (_line);
			}
		}

		public static void C_Run (ConsoleSdtd console)
		{
			if (netCommandQueue.Count > 0) {
				lock (netCommandQueue) {
					issuerOfCurrentCommand = netCommandQueue [0].client;
					try {
						console.ExecuteRemoteCmdInternal (netCommandQueue [0].command, false);
					} catch (Exception e) {
						Log.Out("Exception while executing command: " + e);
					}
					netCommandQueue.RemoveAt (0);
					issuerOfCurrentCommand = null;
				}
			}
		}

		public static void QueueNetCommand (string _line, IConnection _con)
		{
			lock (netCommandQueue) {
				netCommandQueue.Add (new NetCommand (_line, _con));
			}
		}
	}
}
