using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class Unban : ConsoleCommand
	{
		public Unban (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "unban a player";
		}

		public override string[] Names ()
		{
			return new string[] { "unban", string.Empty };
		}

		public override void Run (string[] _params)
		{
			try {
				if (_params.Length != 1) {
					m_Console.SendResult ("Usage: unban <steamid>");
					return;
				}

				long tempLong;
				if (_params [0].Length != 17 || !long.TryParse (_params [0], out tempLong)) {
					m_Console.SendResult ("Not a valid Steam ID.");
					return;
				}

				AdminTools at = CommonMappingFunctions.GetGameManager ().adminTools;
				if (!at.isBanned (_params [0])) {
					m_Console.SendResult ("Steam ID is not banned.");
					return;
				}

				at.RemoveBan (_params [0]);
				m_Console.SendResult ("Removed ban for Steam ID " + _params [0]);
			} catch (Exception e) {
				Log.Out ("Error in Unban.Run: " + e);
			}
		}
	}
}
