using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class ListItems : ConsoleCommand
	{
		public ListItems (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "lists all items that contain the given substring";
		}

		public override string[] Names ()
		{
			return new string[] { "listitems", "li" };
		}

		public override void Run (string[] _params)
		{
			try {
				if (_params.Length != 1 || _params [0].Length == 0) {
					m_Console.SendResult ("Usage: listitems <searchString>");
					return;
				}

				int n = 0;
				foreach (string s in ItemList.Instance.ItemNames) {
					if (s.ToLower ().Contains (_params [0].ToLower ())) {
						m_Console.SendResult ("    " + s);
						n++;
					}
				}

				m_Console.SendResult ("Listed " + n + " matching items.");
			} catch (Exception e) {
				Log.Out ("Error in ListItems.Run: " + e);
			}
		}
	}
}
