using AllocsFixes.CustomCommands;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace AllocsFixes
{
	public class CommandExtensions
	{
		public static void InitCommandExtensions (GameManager manager)
		{
			try {
				ConsoleSdtd cons = manager.m_GUIConsole;
				string ns = "AllocsFixes.CustomCommands";
				string basetype = "ConsoleCommand";

				foreach (Type t in Assembly.GetExecutingAssembly ().GetTypes()) {
					if (t.IsClass && t.Namespace.Equals (ns) && t.BaseType.Name.Equals (basetype)) {
						try {
							ConstructorInfo ctor = t.GetConstructor (new Type[] {typeof(ConsoleSdtd)});
							cons.AddCommand ((ConsoleCommand)ctor.Invoke (new object[] {cons}));
						} catch (Exception e) {
							Log.Out ("Could not register custom command \"" + t.Name + "\": " + e);
						}
					}
				}
			} catch (Exception e) {
				Log.Out ("Error registering custom commands: " + e);
			}
		}
	}
}
