using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Threading;

namespace AllocsFixes.NetConnections.Servers.Web
{
	public class StaticHandler : PathHandler
	{
		private string datapath;
		private string staticPart;
		private AllocsFixes.FileCache.AbstractCache cache;
		private bool logMissingFiles;

		public StaticHandler (string staticPart, string filePath, AllocsFixes.FileCache.AbstractCache cache, bool logMissingFiles)
		{
			this.staticPart = staticPart;
			this.datapath = filePath;
			this.cache = cache;
			this.logMissingFiles = logMissingFiles;
		}

		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, HttpListenerBasicIdentity user)
		{
			try {
				string fn = req.Url.AbsolutePath.Remove (0, staticPart.Length);

				byte[] content = cache.GetFileContent (datapath + "/" + fn);
				if (content != null) {
					resp.ContentType = MimeType.GetMimeType (Path.GetExtension (fn));
					resp.ContentLength64 = content.Length;
					resp.OutputStream.Write (content, 0, content.Length);
				} else {
					resp.StatusCode = (int)HttpStatusCode.NotFound;
					if (logMissingFiles)
						Log.Out ("Web:Static:FileNotFound: \"" + req.Url.AbsolutePath + "\" @ \"" + datapath + "/" + req.Url.AbsolutePath.Remove (0, staticPart.Length) + "\"");
					return;
				}
			} catch (Exception e) {
				Log.Out ("Error in StaticHandler.HandleRequest: " + e);
			}
		}
	}
}

