using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class ListLandProtection : ConsoleCommand
	{
		public ListLandProtection (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "lists all land protection blocks and owners";
		}

		public override string[] Names ()
		{
			return new string[] { "listlandprotection", "llp" };
		}

		public override void ExecuteRemote (string _sender, string[] _params)
		{
			try {
				if (_params.Length >= 1 && _params [0].ToLower ().Equals ("nearby")) {
					string[] params2 = new string[_params.Length + 1];
					for (int i = 0; i < _params.Length; i++)
						params2 [i] = _params [i];
					params2 [_params.Length] = _sender;
					_params = params2;
				}
				Run (_params);
			} catch (Exception e) {
				Log.Out ("Error in ListLandProtection.ExecuteRemote: " + e);
			}
		}

		public override void Run (string[] _params)
		{
			try {
				World w = CommonMappingFunctions.GetGameManager ().World;
				PersistentPlayerList ppl = CommonMappingFunctions.GetGameManager ().GetPersistentPlayerList ();

				bool summaryOnly = false;
				string steamIdFilter = string.Empty;
				Vector3i closeTo = default(Vector3i);
				bool onlyCloseToPlayer = false;
				int closeToDistance = 32;

				if (_params.Length == 1) {
					long tempLong;

					if (_params [0].ToLower ().Equals ("summary")) {
						summaryOnly = true;
					} else if (_params [0].Length == 17 && long.TryParse (_params [0], out tempLong)) {
						steamIdFilter = _params [0];
					} else {
						ClientInfo ci = CommonMappingFunctions.GetClientInfoFromNameOrID (_params [0], true);
						if (ci != null) {
							steamIdFilter = CommonMappingFunctions.GetSteamID (ci);
						} else {
							m_Console.SendResult ("Player name or entity id \"" + _params [0] + "\" not found.");
							return;
						}
					}
				} else if (_params.Length >= 2) {
					if (_params [0].ToLower ().Equals ("nearby")) {
						try {
							if (_params.Length == 3) {
								if (!int.TryParse (_params[1], out closeToDistance)) {
									m_Console.SendResult ("Given radius is not an integer!");
								}
							}
							ClientInfo ci = CommonMappingFunctions.GetClientInfoFromSteamID (_params [_params.Length - 1]);
							EntityPlayer ep = CommonMappingFunctions.GetEntityPlayer (ci);
							closeTo = new Vector3i (ep.GetPosition ());
							onlyCloseToPlayer = true;
						} catch (Exception e) {
							m_Console.SendResult ("Error getting current player's position");
							Log.Out ("Error in ListLandProtection.Run: " + e);
						}
					} else {
						m_Console.SendResult ("Illegal parameter list");
						return;
					}
				}

				Dictionary<Vector3i, PersistentPlayerData> d = ppl.positionToLPBlockOwner;
				if (d != null) {
					Dictionary<PersistentPlayerData, List<Vector3i>> owners = new Dictionary<PersistentPlayerData, List<Vector3i>> ();
					foreach (KeyValuePair<Vector3i, PersistentPlayerData> kvp in d) {
						if (!onlyCloseToPlayer || (Math.Abs (kvp.Key.x - closeTo.x) <= closeToDistance && Math.Abs (kvp.Key.z - closeTo.z) <= closeToDistance)) {
							if (!owners.ContainsKey (kvp.Value)) {
								owners.Add (kvp.Value, new List<Vector3i> ());
							}
							owners [kvp.Value].Add (kvp.Key);
						}
					}

					foreach (KeyValuePair<PersistentPlayerData, List<Vector3i>> kvp in owners) {
						if (steamIdFilter.Length == 0 || kvp.Key.PlayerId.Equals (steamIdFilter)) {
							string name = PersistentData.PersistentContainer.Instance.Players [kvp.Key.PlayerId].Name;
							name += " (" + kvp.Key.PlayerId + ")";

							m_Console.SendResult (String.Format ("Player \"{0}\" owns {3} keystones (protected: {1}, current hardness multiplier: {2})", name, w.LandClaimIsActive (kvp.Key), w.LandClaimPower (kvp.Key), kvp.Value.Count));
							if (!summaryOnly) {
								foreach (Vector3i v in kvp.Value) {
									m_Console.SendResult ("   (" + v.ToString () + ")");
								}
							}
						}
					}
				}

				if (steamIdFilter.Length == 0)
					m_Console.SendResult ("Total of " + d.Count + " keystones in the game");
			} catch (Exception e) {
				Log.Out ("Error in ListLandProtection.Run: " + e);
			}
		}
	}
}
