using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class ListPlayersExtended : ConsoleCommand
	{
		public ListPlayersExtended (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "lists all players with extended attributes";
		}

		public override string[] Names ()
		{
			return new string[] { "listplayersextended", "lpe" };
		}

		public override void Run (string[] _params)
		{
			try {
				World w = CommonMappingFunctions.GetGameManager ().World;
				int num = 0;
				foreach (KeyValuePair<int, EntityPlayer> current in w.playerEntities.dict) {
					ClientInfo ci = CommonMappingFunctions.GetClientInfoFromEntityID (current.Key);
					string ip = string.Empty;
					if (ci != null) {
						ip = ci.networkPlayer.ipAddress;
					}
					m_Console.SendResult (string.Concat (new object[]
						{
							string.Empty,
							++num,
							". id=",
//							current.Value.4E2AA,
							", ",
							current.Value.EntityName,
							", pos=",
							current.Value.GetPosition (),
							", rot=",
							current.Value.rotation,
							", remote=",
//							current.Value.fd00b1,
							", health=",
							current.Value.Health,
							", deaths=",
							current.Value.Died,
							", zombies=",
							current.Value.KilledZombies,
							", players=",
							current.Value.KilledPlayers,
							", score=",
							current.Value.Score,
							", steamid=",
							CommonMappingFunctions.GetSteamID (ci),
							", ip=",
							ip,
							", ping=",
							current.Value.pingToServer
						}
					)
					);
				}
				m_Console.SendResult ("Total of " + w.playerEntities.list.Count + " in the game");
			} catch (Exception e) {
				Log.Out ("Error in ListPlayersExtended.Run: " + e);
			}
		}
	}
}
