#!/bin/bash
# Version 5

# Tries to start the 7dtd instance.

sdtdCommandUpdateengine() {
	for I in $(getInstanceList); do
		if [ $(isRunning $I) -eq 1 ]; then
			echo "At least one instance is still running (\"$I\")."
			echo "Before updating the engine please stop all instances!"
			return
		fi
	done

	if [ ! -e $STEAMCMD_ROOT ]; then
		mkdir $STEAMCMD_ROOT
		cd /tmp
		wget http://media.steampowered.com/installer/steamcmd_linux.tar.gz
		tar -xvzf steamcmd_linux.tar.gz -C $STEAMCMD_ROOT
		cd $STEAMCMD_ROOT
		./steamcmd.sh +quit
	fi

	cd $STEAMCMD_ROOT

	./steamcmd.sh +@sSteamCmdForcePlatformType windows +login $STEAM_USER $STEAM_PASS +force_install_dir $SDTD_BASE/engine "+app_update 251570" validate +quit
	chown $SDTD_USER.$SDTD_GROUP -R $SDTD_BASE/engine

	cp $SDTD_BASE/engine/Install/32bit/7DaysToDie.exe $SDTD_BASE/engine/
	cp $SDTD_BASE/engine/Install/32bit/mono.dll $SDTD_BASE/engine/7DaysToDie_Data/Mono/
	cp $SDTD_BASE/engine/Install/32bit/SteamworksManaged.dll $SDTD_BASE/engine/7DaysToDie_Data/Managed/
}

sdtdCommandUpdateengineHelp() {
	echo "Usage: $(basename $0) updateengine"
	echo
	echo "Update the engine (aka game) files of 7dtd."
}

sdtdCommandUpdateengineDescription() {
	echo "Update the 7dtd engine files"
}
