using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using Steamworks;

namespace AllocsFixes
{
	public class CommonMappingFunctions
	{
		public static ConnectionManager GetConnectionManager ()
		{
			return ConnectionManager.Instance;
		}

		public static GameManager GetGameManager ()
		{
			return GetConnectionManager ().gameManager;
		}

		public static string GetPlayerName (ClientInfo _ci)
		{
			return _ci.playerName;
		}

		public static EntityPlayer GetEntityPlayer (ClientInfo _ci)
		{
			return GetGameManager ().World.playerEntities.dict [_ci.entityId];
		}

		public static string GetSteamID (ClientInfo _ci)
		{
			return _ci.playerId;
		}

		public static int GetClientID (ClientInfo _ci)
		{
			return _ci.clientId;
		}

		public static int GetEntityID (ClientInfo _ci)
		{
			return _ci.entityId;
		}

		public static ClientInfo GetClientInfoFromEntityID (int _entityId)
		{
			try {
				ConnectionManager cm = GetConnectionManager ();

				return cm.GetClientInfoForEntityId (_entityId);
			} catch (Exception e) {
				Log.Out ("Error getting ClientInfo for entity ID: " + e);
			}
			return null;
		}

		public static ClientInfo GetClientInfoFromClientID (int _clientId)
		{
			try {
				ConnectionManager cm = GetConnectionManager ();

				if (cm.connectedClients.ContainsKey (_clientId))
					return cm.connectedClients [_clientId];
				else
					return null;
			} catch (Exception e) {
				Log.Out ("Error getting ClientInfo for client ID: " + e);
			}
			return null;
		}

		public static ClientInfo GetClientInfoFromPlayerName (string _playerName, bool ignoreColorcodes)
		{
			try {
				ConnectionManager cm = GetConnectionManager ();

				_playerName = _playerName.ToLower ();
				if (ignoreColorcodes) {
					_playerName = Regex.Replace (_playerName, "\\[[0-9a-fA-F]{6}\\]", "");
				}
				foreach (ClientInfo ci in cm.connectedClients.Values) {
					string curName = GetPlayerName (ci).ToLower ();
					if (ignoreColorcodes) {
						curName = Regex.Replace (curName, "\\[[0-9a-fA-F]{6}\\]", "");
					}
					if (curName.Equals (_playerName)) {
						return ci;
					}
				}
			} catch (Exception e) {
				Log.Out ("Error getting ClientInfo for player name: " + e);
			}
			return null;
		}

		public static ClientInfo GetClientInfoFromNameOrID (string _nameOrId, bool ignoreColorcodes)
		{
			try {
				long tempLong;
				if (_nameOrId.Length == 17 && long.TryParse (_nameOrId, out tempLong)) {
					return GetClientInfoFromSteamID (_nameOrId);
				} else {
					int entityId = -1;
					if (int.TryParse (_nameOrId, out entityId)) {
						ClientInfo ci = GetClientInfoFromEntityID (entityId);
						if (ci != null)
							return ci;
					}

					return GetClientInfoFromPlayerName (_nameOrId, ignoreColorcodes);
				}
			} catch (Exception e) {
				Log.Out ("Error getting ClientInfo for steam ID / entity ID / player name \"" + _nameOrId + "\": " + e);
			}
			return null;
		}

		public static ClientInfo GetClientInfoFromSteamID (string _steamId)
		{
			return GetConnectionManager ().GetClientInfoForPlayerId (_steamId);
		}

	}
}
