#!/bin/bash

. /usr/local/lib/7dtd/common.sh
. /usr/local/lib/7dtd/playerlog.sh

if [ $(isValidInstance $1) -eq 0 ]; then
	echo "No instance given or not a valid instance!"
	return
fi

INSTANCE=$1
LOG=$2
#LOG=$(getInstancePath $INSTANCE)/logs/$(date '+%Y-%m-%d_%H-%M-%S')_output_log.txt
CHATLOG=$(getInstancePath $INSTANCE)/logs/$(date '+%Y-%m-%d_%H-%M-%S')_chat.log
COMMANDLOG=$(getInstancePath $INSTANCE)/logs/$(date '+%Y-%m-%d_%H-%M-%S')_commandExecution.log

timestamp() {
	date '+%Y.%m.%d %H:%M:%S'
}

handleConnect() {
	local clientId="$1"
	local entityId="$2"
	local name="$3"
	local steamId="$4"
	local ip="$5"
	
	logPlayerConnect $INSTANCE "$entityId" "$name" "$steamId" "$ip"

	for H in $(getHooksFor playerConnect); do
		$H $INSTANCE "$clientId" "$entityId" "$name" "$steamId" "$ip"
	done
}

handleDisconnect() {
	local clientId="$1"
	local entityId="$2"

	logPlayerDisconnect $INSTANCE "$entityId"

	for H in $(getHooksFor playerDisconnect); do
		$H $INSTANCE "$clientId" "$entityId" "$NICKNAME" "$STEAMID"
	done
}

handleChat() {
	echo "$(timestamp): $1" >> $CHATLOG
	
	for H in $(getHooksFor chat); do
		$H $INSTANCE "$1"
	done
}

handleRemoteCommand() {
	local cmd="$1"
	local name="$2"
	
	echo "$(timestamp): Player \"$name\" executed \"$cmd\"" >> $COMMANDLOG

	for H in $(getHooksFor remoteCommand); do
		$H $INSTANCE "$cmd" "$name"
	done
}

handleTelnetCommand() {
	local cmd="$1"
	local ip="$2"

	echo "$(timestamp): Telnet from \"$ip\" executed \"$cmd\"" >> $COMMANDLOG

	for H in $(getHooksFor telnetCommand); do
		$H $INSTANCE "$cmd" "$ip"
	done
}


if [ ! -d "$(getInstancePath $INSTANCE)/logs" ]; then
	mkdir "$(getInstancePath $INSTANCE)/logs"
fi

setAllPlayersOffline

rm $(getInstancePath $INSTANCE)/logs/current_output_log.txt
rm $(getInstancePath $INSTANCE)/logs/current_chat.log
rm $(getInstancePath $INSTANCE)/logs/current_commandExecution.log
ln -s $LOG $(getInstancePath $INSTANCE)/logs/current_output_log.txt
ln -s $CHATLOG $(getInstancePath $INSTANCE)/logs/current_chat.log
ln -s $COMMANDLOG $(getInstancePath $INSTANCE)/logs/current_commandExecution.log

sleep 5

NOBUF="stdbuf -e0 -o0"

$NOBUF tail -n 5000 -F $LOG |
$NOBUF tr '\\' '/' |
$NOBUF tr -d '\r' |
$NOBUF grep -v "^(Filename: " |
$NOBUF sed -r 's/^[0-9]+-[0-9]+-[0-9]+T[0-9]+:[0-9]+:[0-9]+ [0-9]+[.,][0-9]+ [A-Z]+ (.*)$/\1/' |
while read line ; do
	if [ -n "$line" ]; then
		#Player connected, clientid=[0-9]*, entityid=[0-9]*, name=.*, steamid=[0-9]*, ip=[0-9.]*$
		if [ -n "$(echo "$line" | grep '^Player connected,')" ]; then
			clientId=$(expr "$line" : 'Player connected, clientid=\([0-9]*\), entityid=[0-9]*, name=.*, steamid=[0-9]*, ip=[0-9.]*$')
			entityId=$(expr "$line" : 'Player connected, clientid=[0-9]*, entityid=\([0-9]*\), name=.*, steamid=[0-9]*, ip=[0-9.]*$')
			playerName=$(expr "$line" : 'Player connected, clientid=[0-9]*, entityid=[0-9]*, name=\(.*\), steamid=[0-9]*, ip=[0-9.]*$')
			steamId=$(expr "$line" : 'Player connected, clientid=[0-9]*, entityid=[0-9]*, name=.*, steamid=\([0-9]*\), ip=[0-9.]*$')
			ip=$(expr "$line" : 'Player connected, clientid=[0-9]*, entityid=[0-9]*, name=.*, steamid=[0-9]*, ip=\([0-9.]*\)$')
			sleep 1
			handleConnect "$clientId" "$entityId" "$playerName" "$steamId" "$ip"
			unset clientId entityId playerName steamId ip
		else
		#Removing player with id clientId=[0-9]*, entityId=[0-9]*$
		if [ -n "$(echo "$line" | grep '^Removing player with id ')" ]; then
			playerId=$(expr "$line" : 'Removing player with id clientId=\([0-9]*\), entityId=[0-9]*$')
			entityId=$(expr "$line" : 'Removing player with id clientId=[0-9]*, entityId=\([0-9]*\)$')
			handleDisconnect "$playerId" "$entityId"
			unset playerId entityId
		else
		#GMSG: .*$
		if [ -n "$(echo "$line" | grep -E '^GMSG: .+')" ]; then
			msg=$(expr "$line" : 'GMSG: \(.*\)$')
			handleChat "$msg"
			unset msg
		else
		#Executed command ".*" from player ".*"$
		if [ -n "$(echo "$line" | grep '^Executed command ')" ]; then
			cmd=$(expr "$line" : 'Executed command "\(.*\)" from player ".*"$')
			nick=$(expr "$line" : 'Executed command ".*" from player "\(.*\)"$')
			handleRemoteCommand "$cmd" "$nick"
			unset cmd nick
		else
		#Telnet executed ".*" from: .*$
		if [ -n "$(echo "$line" | grep '^Telnet executed ')" ]; then
			cmd=$(expr "$line" : 'Telnet executed "\(.*\)" from: .*$')
			ip=$(expr "$line" : 'Telnet executed ".*" from: \(.*\)$')
			handleTelnetCommand "$cmd" "$ip"
			unset cmd ip
		fi
		fi
		fi
		fi
		fi
	fi
done
