using System;

namespace AllocsFixes
{
	public abstract class ModAPI {
		public ModAPI () {
		}

		public abstract string ModName ();

		public abstract string ModVersion ();

		public virtual void GameAwake () {
		}

		public virtual void GameShutdown () {
		}

		public virtual void SavePlayerData (int _clientId, PlayerDataFile _playerDataFile) {
		}

		public virtual void RequestToSpawnPlayer (int _clientId, string _name, int _chunkViewDim, PlayerProfile _playerProfile) {
		}

		public virtual void PlayerDisconnected (ClientInfo _cInfo, bool _bShutdown) {
		}

		public virtual void CalcMapColors (Chunk _chunk) {
		}
	}
}

