using System;
using System.Collections.Generic;
using System.Reflection;

namespace AllocsFixes.CustomCommands
{
	public class Version : ConsoleCommand
	{
		public Version (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "get the currently running version of the server fixes and loaded mods";
		}

		public override string[] Names ()
		{
			return new string[] { "version", string.Empty };
		}

		public override void Run (string[] _params)
		{
			try {
				m_Console.SendResult ("Versions:");
				m_Console.SendResult ("Server fixes: " + Assembly.GetExecutingAssembly ().GetName ().Version);
				foreach (Mods.ModData md in Mods.LoadedMods ()) {
					m_Console.SendResult ("Mod " + md.name + ": " + md.version);
				}
			} catch (Exception e) {
				Log.Out ("Error in Version.Run: " + e);
			}
		}
	}
}
