using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class Kill : ConsoleCommand
	{
		public Kill (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "kill a given player (entity id or name)";
		}

		public override string[] Names ()
		{
			return new string[] { "kill", string.Empty };
		}

		public override void Run (string[] _params)
		{
			try {
				if (_params.Length != 1) {
					m_Console.SendResult ("Usage: kill <playername|entityid>");
					return;
				}

				ClientInfo ci = CommonMappingFunctions.GetClientInfoFromNameOrID (_params [0], false);

				if (ci == null) {
					m_Console.SendResult ("Playername or entity id not found.");
					return;
				}

				EntityPlayer p = CommonMappingFunctions.GetEntityPlayer (ci);
				p.DamageEntity (new DamageSource (EnumDamageSourceType.Bullet), 9999, false);
				m_Console.SendResult ("Killed player " + _params [0]);
			} catch (Exception e) {
				Log.Out ("Error in Kill.Run: " + e);
			}
		}
	}
}
